# cPanel Quick Start Guide
## Payment Summary System - 5 Minute Setup

Quick reference for experienced users deploying to cPanel.

---

## ⚡ Quick Steps

### 1. Upload Files
```
Upload entire project to: public_html/payments/
(or public_html/ if using root domain)
```

### 2. Create Database
```
cPanel → MySQL Databases
- Create database: username_payments
- Create user: username_payuser
- Add user to database with ALL PRIVILEGES
```

### 3. Import Database
```
cPanel → phpMyAdmin
- Select database
- Import → database/migrate_all.sql
```

### 4. Configure Environment
```bash
# Create .env file
cp env.production.example .env

# Edit .env with production values:
APP_URL="https://yourdomain.com/payments/public"
DB_NAME="username_payments"
DB_USER="username_payuser"
DB_PASS="your_password"
TELEGRAM_BOT_TOKEN="your_token"
TELEGRAM_WEBHOOK_SECRET="generate_with_php_random_bytes"

# Set permissions
chmod 600 .env
```

### 5. Set Permissions
```bash
chmod -R 755 storage/
chmod -R 755 storage/logs/
chmod -R 755 storage/cache/
```

### 6. Enable HTTPS (if needed)
Edit `.htaccess` in root and `public/.htaccess`:
```apache
# Uncomment these lines:
RewriteCond %{HTTPS} off
RewriteCond %{HTTP:X-Forwarded-Proto} !https
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

### 7. Configure PHP
```
cPanel → Select PHP Version
- PHP 7.4+ (8.3+ recommended)
- Enable: PDO, PDO_MySQL, JSON, mbstring, curl
```

### 8. Set Webhook
```
https://api.telegram.org/botYOUR_TOKEN/setWebhook?url=https://yourdomain.com/payments/public/webhook.php&secret_token=YOUR_SECRET
```

### 9. Test
```
Visit: https://yourdomain.com/payments/public/install-check.php
```

---

## 🔑 Generate Webhook Secret

**Via SSH:**
```bash
php -r "echo bin2hex(random_bytes(32));"
```

**Via PHP file:**
```php
<?php
echo bin2hex(random_bytes(32));
?>
```

---

## 📍 Important Paths

- **Application**: `public_html/payments/public/`
- **Config**: `public_html/payments/.env`
- **Logs**: `public_html/payments/storage/logs/system.log`
- **Database**: cPanel → phpMyAdmin

---

## ✅ Quick Verification

1. **Install Check**: `/public/install-check.php` - All green?
2. **Login**: `/public/login.php` - Works?
3. **Webhook**: Send test message - Received?

---

## 🆘 Common Issues

| Issue | Solution |
|-------|----------|
| 500 Error | Check `.htaccess`, PHP version, permissions |
| DB Error | Verify credentials, user permissions |
| Webhook Fails | Check HTTPS, secret token, logs |
| Permissions | `chmod 755 storage/`, `chmod 600 .env` |

---

## 📚 Full Documentation

- **Complete Guide**: [CPANEL_DEPLOYMENT.md](CPANEL_DEPLOYMENT.md)
- **Checklist**: [DEPLOYMENT_CHECKLIST.md](DEPLOYMENT_CHECKLIST.md)
- **Configuration**: [CONFIGURATION.md](CONFIGURATION.md)

---

**Need help?** See [CPANEL_DEPLOYMENT.md](CPANEL_DEPLOYMENT.md) for detailed instructions.
