# Deployment Checklist
## Payment Summary System - Production Deployment

Use this checklist to ensure a smooth deployment to production.

---

## 📦 Pre-Deployment

### Code Preparation
- [ ] All code tested locally
- [ ] All security features verified
- [ ] Remove or secure test files
- [ ] Update `.env` with production values
- [ ] Verify `.htaccess` files are correct
- [ ] Check all file paths are correct

### Files to Review
- [ ] `.env` - Production configuration ready
- [ ] `.htaccess` - HTTPS redirect configured (uncomment for production)
- [ ] `public/.htaccess` - Security headers enabled
- [ ] `database/migrate_all.sql` - Database schema ready

---

## 🚀 Deployment Steps

### 1. Server Setup
- [ ] cPanel/hosting account ready
- [ ] PHP 7.4+ selected in cPanel
- [ ] Required PHP extensions enabled (PDO, PDO_MySQL, JSON, mbstring, curl)
- [ ] SSL certificate installed
- [ ] Domain configured

### 2. File Upload
- [ ] All files uploaded to server
- [ ] Folder structure maintained
- [ ] `.htaccess` files uploaded
- [ ] File permissions set correctly

### 3. Database Setup
- [ ] Database created in cPanel
- [ ] Database user created
- [ ] User granted permissions
- [ ] Database imported successfully
- [ ] Tables verified (users, organizations, transactions, etc.)

### 4. Configuration
- [ ] `.env` file created with production values
- [ ] `APP_ENV` set to `"production"`
- [ ] `APP_DEBUG` set to `"false"`
- [ ] Database credentials configured
- [ ] `APP_URL` set to production domain
- [ ] Telegram bot token configured
- [ ] Webhook secret generated and configured
- [ ] `.env` file permissions set to `600`

### 5. File Permissions
- [ ] `storage/` directory: `755`
- [ ] `storage/logs/` directory: `755`
- [ ] `storage/cache/` directory: `755`
- [ ] `.env` file: `600`
- [ ] `.htaccess` files: `644`

### 6. Security Configuration
- [ ] HTTPS redirect enabled in `.htaccess`
- [ ] `.env` file protected from web access
- [ ] Security headers verified
- [ ] CSRF protection active
- [ ] Rate limiting configured
- [ ] Default passwords changed

### 7. Telegram Webhook
- [ ] Webhook URL configured
- [ ] Webhook secret token set
- [ ] Webhook registered with Telegram
- [ ] Webhook verified via API
- [ ] Test message sent and received

### 8. Testing
- [ ] Installation checker passes: `/public/install-check.php`
- [ ] Login page accessible
- [ ] Registration works
- [ ] Dashboard loads correctly
- [ ] Transaction list displays
- [ ] Summary reports work
- [ ] Webhook receives messages
- [ ] Database operations work
- [ ] No errors in logs

---

## ✅ Post-Deployment Verification

### Functionality Tests
- [ ] User registration
- [ ] User login
- [ ] Organization creation
- [ ] Transaction display
- [ ] Summary reports (daily, weekly, monthly, yearly)
- [ ] Admin functions
- [ ] Settings page
- [ ] Telegram webhook processing

### Security Tests
- [ ] HTTPS redirect working
- [ ] CSRF protection active (test form submission)
- [ ] Rate limiting working (test multiple login attempts)
- [ ] Security headers present (check browser dev tools)
- [ ] `.env` file not accessible via browser
- [ ] Error messages don't leak information

### Performance Tests
- [ ] Page load times acceptable
- [ ] Database queries optimized
- [ ] No memory leaks
- [ ] Logs not growing too fast

---

## 📊 Monitoring Setup

### Logs
- [ ] Error logging working: `storage/logs/system.log`
- [ ] Log rotation configured (if needed)
- [ ] Logs accessible via cPanel/SSH

### Backups
- [ ] Database backup strategy in place
- [ ] Backup schedule configured (cron job if needed)
- [ ] Backup location secure
- [ ] Backup restoration tested

### Monitoring
- [ ] Error monitoring set up
- [ ] Performance monitoring (if available)
- [ ] Uptime monitoring (if needed)

---

## 🔧 Troubleshooting Reference

### Common Issues
- [ ] 500 Error → Check `.htaccess`, PHP version, file permissions
- [ ] Database Error → Verify credentials, user permissions
- [ ] Webhook Not Working → Check HTTPS, secret token, logs
- [ ] CSS/JS Not Loading → Check file paths, permissions
- [ ] Permission Denied → Check file/directory permissions

### Support Resources
- [ ] README.md reviewed
- [ ] CPANEL_DEPLOYMENT.md reviewed
- [ ] CONFIGURATION.md reviewed
- [ ] SECURITY.md reviewed
- [ ] Hosting support contact info available

---

## 📝 Final Steps

### Documentation
- [ ] Production URL documented
- [ ] Admin credentials secured
- [ ] Database credentials secured
- [ ] Telegram bot token secured
- [ ] Webhook secret secured

### Handoff
- [ ] All credentials provided to team
- [ ] Access granted to necessary personnel
- [ ] Documentation shared
- [ ] Support contacts provided

---

## 🎯 Quick Test Commands

### Via Browser
```
https://yourdomain.com/payments/public/install-check.php
https://yourdomain.com/payments/public/login.php
https://yourdomain.com/payments/public/
```

### Via SSH (if available)
```bash
# Check PHP version
php -v

# Test database connection
php -r "require 'app/Config/db.php'; echo 'Connected!';"

# View recent logs
tail -20 storage/logs/system.log

# Check file permissions
ls -la storage/
ls -la .env
```

### Via cPanel
- File Manager → Check file permissions
- phpMyAdmin → Verify database tables
- Error Log → Check for errors
- Select PHP Version → Verify PHP version

---

## 📞 Emergency Contacts

- **Hosting Support**: [Your hosting support contact]
- **Developer**: [Your contact]
- **Documentation**: See CPANEL_DEPLOYMENT.md

---

**Deployment Date**: _______________  
**Deployed By**: _______________  
**Production URL**: _______________  
**Status**: ☐ In Progress  ☐ Complete  ☐ Issues Found

---

**Last Updated**: 2024
