<?php

require_once __DIR__ . '/../Helpers/Env.php';

Env::load();

$DB_HOST = Env::get('DB_HOST', 'localhost');
$DB_NAME = Env::get('DB_NAME', 'sumtel');
$DB_USER = Env::get('DB_USER', 'root');
$DB_PASS = Env::get('DB_PASS', '');
$DB_CHARSET = Env::get('DB_CHARSET', 'utf8mb4');

try {
    $pdo = new PDO(
        "mysql:host={$DB_HOST};dbname={$DB_NAME};charset={$DB_CHARSET}",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ]
    );
} catch (Exception $e) {
    die("Database connection failed: " . $e->getMessage());
}

return $pdo;
