<?php

class PricingController
{
    private $pdo;
    private $plan;
    private $subscription;

    public function __construct($pdo)
    {
        $this->pdo = $pdo;
        $this->plan = new Plan($pdo);
        $this->subscription = new Subscription($pdo);
    }

    // Show pricing page
    public function index()
    {
        $plans = $this->plan->all(true);
        $billingPeriod = $_GET['period'] ?? 'monthly'; // monthly or annual
        
        // Get current subscription if logged in
        $currentSubscription = null;
        if (Session::isAuthenticated()) {
            $organization = Session::getOrganization();
            if ($organization) {
                $currentSubscription = $this->subscription->getActive($organization['id']);
            }
        }

        $title = "Pricing";
        include __DIR__ . '/../../views/layouts/main.php';
        include __DIR__ . '/../../views/pricing/index.php';
        include __DIR__ . '/../../views/layouts/footer.php';
    }

    // Handle subscription selection
    public function subscribe()
    {
        if (!Session::isAuthenticated()) {
            Session::flash('error', 'Please login to subscribe.');
            header('Location: login.php?redirect=pricing.php');
            exit;
        }

        $organization = Session::getOrganization();
        if (!$organization) {
            Session::flash('error', 'No organization found.');
            header('Location: index.php');
            exit;
        }

        $planId = $_POST['plan_id'] ?? null;
        $billingPeriod = $_POST['billing_period'] ?? 'monthly';

        if (!$planId) {
            Session::flash('error', 'Please select a plan.');
            header('Location: pricing.php');
            exit;
        }

        $plan = $this->plan->findById($planId);
        if (!$plan) {
            Session::flash('error', 'Invalid plan selected.');
            header('Location: pricing.php');
            exit;
        }

        // Check if already has active subscription
        $existing = $this->subscription->getActive($organization['id']);
        if ($existing) {
            Session::flash('error', 'You already have an active subscription.');
            header('Location: settings.php');
            exit;
        }

        // Create subscription (in real app, this would integrate with payment gateway)
        // For now, we'll create a trial subscription
        $subscriptionId = $this->subscription->createTrial($organization['id'], $planId, 14);
        
        if ($subscriptionId) {
            Session::flash('success', 'Subscription activated! You are now on a 14-day trial.');
            header('Location: settings.php');
        } else {
            Session::flash('error', 'Failed to create subscription. Please try again.');
            header('Location: pricing.php');
        }
        exit;
    }
}

