<?php

class SummaryController
{
    private $transaction;

    public function __construct($pdo)
    {
        $this->transaction = new Transaction($pdo);
    }

    public function daily($organizationId = null)
    {
        $today = date("Y-m-d");
        $data = $this->transaction->filter($today, $today, $organizationId);
        $stats = $this->transaction->getStats($today, $today, $organizationId);
        $byBank = $this->transaction->getStatsByBank($today, $today, $organizationId);
        $topMerchants = $this->transaction->getTopMerchants($today, $today, 5, $organizationId);

        $total = $stats['total_amount'] ?? array_sum(array_column($data, 'amount'));
        $count = $stats['total_count'] ?? count($data);

        return [
            'title' => "Daily Summary - " . date("F j, Y", strtotime($today)),
            'date' => $today,
            'total' => $total,
            'count' => $count,
            'data'  => $data,
            'stats' => $stats,
            'byBank' => $byBank,
            'topMerchants' => $topMerchants,
            'period' => 'daily'
        ];
    }

    public function weekly($organizationId = null)
    {
        $start = date("Y-m-d", strtotime("monday this week"));
        $end   = date("Y-m-d", strtotime("sunday this week"));

        $data = $this->transaction->filter($start, $end, $organizationId);
        $stats = $this->transaction->getStats($start, $end, $organizationId);
        $byBank = $this->transaction->getStatsByBank($start, $end, $organizationId);
        $dailyBreakdown = $this->transaction->getDailyBreakdown($start, $end, $organizationId);
        $topMerchants = $this->transaction->getTopMerchants($start, $end, 10, $organizationId);

        $total = $stats['total_amount'] ?? array_sum(array_column($data, 'amount'));
        $count = $stats['total_count'] ?? count($data);

        return [
            'title' => "Weekly Summary",
            'subtitle' => date("M j", strtotime($start)) . " - " . date("M j, Y", strtotime($end)),
            'start' => $start,
            'end' => $end,
            'total' => $total,
            'count' => $count,
            'data'  => $data,
            'stats' => $stats,
            'byBank' => $byBank,
            'dailyBreakdown' => $dailyBreakdown,
            'topMerchants' => $topMerchants,
            'period' => 'weekly'
        ];
    }

    public function monthly($organizationId = null)
    {
        $start = date("Y-m-01");
        $end   = date("Y-m-t");

        $data = $this->transaction->filter($start, $end, $organizationId);
        $stats = $this->transaction->getStats($start, $end, $organizationId);
        $byBank = $this->transaction->getStatsByBank($start, $end, $organizationId);
        $dailyBreakdown = $this->transaction->getDailyBreakdown($start, $end, $organizationId);
        $topMerchants = $this->transaction->getTopMerchants($start, $end, 10, $organizationId);

        $total = $stats['total_amount'] ?? array_sum(array_column($data, 'amount'));
        $count = $stats['total_count'] ?? count($data);

        return [
            'title' => "Monthly Summary",
            'subtitle' => date("F Y"),
            'start' => $start,
            'end' => $end,
            'total' => $total,
            'count' => $count,
            'data'  => $data,
            'stats' => $stats,
            'byBank' => $byBank,
            'dailyBreakdown' => $dailyBreakdown,
            'topMerchants' => $topMerchants,
            'period' => 'monthly'
        ];
    }

    public function yearly($organizationId = null)
    {
        $year = date("Y");
        $start = "$year-01-01";
        $end   = "$year-12-31";

        $data = $this->transaction->filter($start, $end, $organizationId);
        $stats = $this->transaction->getStats($start, $end, $organizationId);
        $byBank = $this->transaction->getStatsByBank($start, $end, $organizationId);
        $dailyBreakdown = $this->transaction->getDailyBreakdown($start, $end, $organizationId);
        $topMerchants = $this->transaction->getTopMerchants($start, $end, 15, $organizationId);

        $total = $stats['total_amount'] ?? array_sum(array_column($data, 'amount'));
        $count = $stats['total_count'] ?? count($data);

        return [
            'title' => "Yearly Summary",
            'subtitle' => $year,
            'year' => $year,
            'start' => $start,
            'end' => $end,
            'total' => $total,
            'count' => $count,
            'data'  => $data,
            'stats' => $stats,
            'byBank' => $byBank,
            'dailyBreakdown' => $dailyBreakdown,
            'topMerchants' => $topMerchants,
            'period' => 'yearly'
        ];
    }

    public function getDashboardStats($organizationId = null)
    {
        $today = date("Y-m-d");
        $thisWeekStart = date("Y-m-d", strtotime("monday this week"));
        $thisWeekEnd = date("Y-m-d", strtotime("sunday this week"));
        $thisMonthStart = date("Y-m-01");
        $thisMonthEnd = date("Y-m-t");
        $thisYearStart = date("Y-01-01");
        $thisYearEnd = date("Y-12-31");

        return [
            'today' => $this->transaction->getStats($today, $today, $organizationId),
            'thisWeek' => $this->transaction->getStats($thisWeekStart, $thisWeekEnd, $organizationId),
            'thisMonth' => $this->transaction->getStats($thisMonthStart, $thisMonthEnd, $organizationId),
            'thisYear' => $this->transaction->getStats($thisYearStart, $thisYearEnd, $organizationId),
            'allTime' => $this->transaction->getStats(null, null, $organizationId),
            'recent' => $this->transaction->getRecent(5, $organizationId),
            'topMerchants' => $this->transaction->getTopMerchants(null, null, 5, $organizationId),
            'byBank' => $this->transaction->getStatsByBank(null, null, $organizationId)
        ];
    }
}
