<?php
require_once __DIR__ . '/../routes/web.php';

Authenticate::handle();

$admin = new AdminUsersController($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'store':
            $admin->store();
            break;
        case 'update':
            $admin->update();
            break;
        case 'delete':
            $admin->delete();
            break;
        case 'set_webhook':
            $admin->setWebhook();
            break;
        case 'delete_webhook':
            $admin->deleteWebhook();
            break;
        default:
            header('Location: admin-users.php');
            exit;
    }
} else {
    $action = $_GET['action'] ?? 'index';
    
    switch ($action) {
        case 'create':
            $admin->create();
            break;
        case 'edit':
            $admin->edit();
            break;
        default:
            $admin->index();
    }
}

