<?php
require_once __DIR__ . '/../routes/web.php';

Authenticate::handle();

$organization = Session::getOrganization();
if (!$organization) {
    Session::flash('error', 'No organization found.');
    header('Location: index.php');
    exit;
}

$summary = new SummaryController($pdo);

$type = $_GET['type'] ?? 'daily';

switch ($type) {
    case 'weekly':
        $result = $summary->weekly($organization['id']);
        $view = "weekly.php";
        break;

    case 'monthly':
        $result = $summary->monthly($organization['id']);
        $view = "monthly.php";
        break;

    case 'yearly':
        $result = $summary->yearly($organization['id']);
        $view = "yearly.php";
        break;

    default:
        $result = $summary->daily($organization['id']);
        $view = "daily.php";
}

// Extract all variables from result
extract($result);

// Include the main layout
include __DIR__ . '/../views/layouts/main.php';
?>

<?php include __DIR__ . '/../views/summary/' . $view; ?>

<?php include __DIR__ . '/../views/layouts/footer.php'; ?>
