<?php
require_once __DIR__ . '/../routes/web.php';

Authenticate::handle();

$organization = Session::getOrganization();
if (!$organization) {
    Session::flash('error', 'No organization found.');
    header('Location: index.php');
    exit;
}

$transaction = new Transaction($pdo);

// Get filter parameters
$search = trim($_GET['search'] ?? '');
$bank = $_GET['bank'] ?? '';
$dateFrom = $_GET['date_from'] ?? '';
$dateTo = $_GET['date_to'] ?? '';

// Pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page = max(1, $page);
$perPage = 25;
$offset = ($page - 1) * $perPage;

// Get all transactions for this organization (for filtering)
$allData = $transaction->all(null, 0, $organization['id']);

// Apply filters
if (!empty($search) || !empty($bank) || (!empty($dateFrom) && !empty($dateTo))) {
    $allData = array_filter($allData, function($row) use ($search, $bank, $dateFrom, $dateTo) {
        // Search filter
        if (!empty($search)) {
            $matches = stripos($row['payer_name'] ?? '', $search) !== false ||
                      stripos($row['merchant'] ?? '', $search) !== false ||
                      stripos($row['reference_id'] ?? '', $search) !== false;
            if (!$matches) return false;
        }
        
        // Bank filter
        if (!empty($bank) && ($row['bank'] ?? '') !== $bank) {
            return false;
        }
        
        // Date range filter
        if (!empty($dateFrom) && !empty($dateTo)) {
            $rowDate = $row['date'] ?? '';
            if ($rowDate < $dateFrom || $rowDate > $dateTo) {
                return false;
            }
        }
        
        return true;
    });
    
    // Re-index array
    $allData = array_values($allData);
}

// Calculate pagination
$totalCount = count($allData);
$totalPages = ceil($totalCount / $perPage);

// Apply pagination
$data = array_slice($allData, $offset, $perPage);

// Get unique banks for filter dropdown
$uniqueBanks = array_unique(array_column($transaction->all(null, 0, $organization['id']), 'bank'));
$uniqueBanks = array_filter($uniqueBanks);

// Get statistics
$stats = $transaction->getStats(null, null, $organization['id']);

$pagination = [
    'page' => $page,
    'perPage' => $perPage,
    'totalCount' => $totalCount,
    'totalPages' => $totalPages
];

$title = "All Transactions";
include __DIR__ . '/../views/transactions/list.php';
