<?php
$plan = $plan ?? null;
$isEdit = isset($plan);
$features = $plan ? json_decode($plan['features'] ?? '[]', true) : [];
$featuresText = is_array($features) ? implode("\n", $features) : '';
?>

<div class="mb-8">
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-mono-900 mb-2"><?= $isEdit ? 'Edit Plan' : 'Create New Plan' ?></h1>
            <p class="text-mono-600"><?= $isEdit ? 'Update plan details' : 'Add a new subscription plan' ?></p>
        </div>
        <a href="admin-plans.php" class="text-mono-600 hover:text-mono-900">
            ← Back to Plans
        </a>
    </div>
</div>

<?php if ($error = Session::flash('error')): ?>
    <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg text-red-700">
        <?= htmlspecialchars($error) ?>
    </div>
<?php endif; ?>

<div class="bg-white rounded-lg shadow-sm border border-mono-200 p-8">
    <form method="POST" action="admin-plans.php" class="space-y-6">
        <?= Security::csrfField() ?>
        <input type="hidden" name="action" value="<?= $isEdit ? 'update' : 'store' ?>">
        <?php if ($isEdit): ?>
            <input type="hidden" name="id" value="<?= $plan['id'] ?>">
        <?php endif; ?>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Plan Name -->
            <div class="md:col-span-2">
                <label for="name" class="block text-sm font-medium text-mono-700 mb-2">Plan Name *</label>
                <input type="text" id="name" name="name" required
                       value="<?= htmlspecialchars($plan['name'] ?? '') ?>"
                       placeholder="e.g., Starter, Professional, Enterprise"
                       class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                <p class="mt-1 text-xs text-mono-500">A unique name for this plan</p>
            </div>

            <!-- Description -->
            <div class="md:col-span-2">
                <label for="description" class="block text-sm font-medium text-mono-700 mb-2">Description</label>
                <textarea id="description" name="description" rows="2"
                          placeholder="Brief description of what this plan offers"
                          class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"><?= htmlspecialchars($plan['description'] ?? '') ?></textarea>
            </div>

            <!-- Monthly Price -->
            <div>
                <label for="price_monthly" class="block text-sm font-medium text-mono-700 mb-2">Monthly Price *</label>
                <div class="relative">
                    <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-mono-500">$</span>
                    <input type="number" id="price_monthly" name="price_monthly" required step="0.01" min="0"
                           value="<?= htmlspecialchars($plan['price_monthly'] ?? '0.00') ?>"
                           placeholder="0.00"
                           class="w-full pl-8 pr-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                </div>
            </div>

            <!-- Annual Price -->
            <div>
                <label for="price_annual" class="block text-sm font-medium text-mono-700 mb-2">Annual Price *</label>
                <div class="relative">
                    <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-mono-500">$</span>
                    <input type="number" id="price_annual" name="price_annual" required step="0.01" min="0"
                           value="<?= htmlspecialchars($plan['price_annual'] ?? '0.00') ?>"
                           placeholder="0.00"
                           class="w-full pl-8 pr-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                </div>
                <p class="mt-1 text-xs text-mono-500">Typically 10-17% discount from monthly</p>
            </div>

            <!-- Features -->
            <div class="md:col-span-2">
                <label for="features" class="block text-sm font-medium text-mono-700 mb-2">Features</label>
                <textarea id="features" name="features" rows="6"
                          placeholder="Enter one feature per line:&#10;Up to 1,000 transactions/month&#10;1 organization&#10;Up to 3 team members&#10;Basic reports&#10;Email support"
                          class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none font-mono text-sm"><?= htmlspecialchars($featuresText) ?></textarea>
                <p class="mt-1 text-xs text-mono-500">Enter one feature per line. These will be displayed as a bulleted list.</p>
            </div>

            <!-- Max Transactions -->
            <div>
                <label for="max_transactions" class="block text-sm font-medium text-mono-700 mb-2">Max Transactions/Month</label>
                <input type="number" id="max_transactions" name="max_transactions" min="0"
                       value="<?= htmlspecialchars($plan['max_transactions'] ?? '') ?>"
                       placeholder="Leave empty for unlimited"
                       class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                <p class="mt-1 text-xs text-mono-500">Leave empty for unlimited</p>
            </div>

            <!-- Max Users -->
            <div>
                <label for="max_users" class="block text-sm font-medium text-mono-700 mb-2">Max Team Members</label>
                <input type="number" id="max_users" name="max_users" min="0"
                       value="<?= htmlspecialchars($plan['max_users'] ?? '') ?>"
                       placeholder="Leave empty for unlimited"
                       class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                <p class="mt-1 text-xs text-mono-500">Leave empty for unlimited</p>
            </div>

            <!-- Max Organizations -->
            <div>
                <label for="max_organizations" class="block text-sm font-medium text-mono-700 mb-2">Max Organizations</label>
                <input type="number" id="max_organizations" name="max_organizations" min="1"
                       value="<?= htmlspecialchars($plan['max_organizations'] ?? '1') ?>"
                       class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
            </div>

            <!-- Sort Order -->
            <div>
                <label for="sort_order" class="block text-sm font-medium text-mono-700 mb-2">Sort Order</label>
                <input type="number" id="sort_order" name="sort_order" min="0"
                       value="<?= htmlspecialchars($plan['sort_order'] ?? '0') ?>"
                       class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                <p class="mt-1 text-xs text-mono-500">Lower numbers appear first on pricing page</p>
            </div>

            <!-- Active Status -->
            <div class="md:col-span-2">
                <label class="flex items-center">
                    <input type="checkbox" name="is_active" value="1"
                           <?= ($plan['is_active'] ?? 1) ? 'checked' : '' ?>
                           class="h-4 w-4 text-mono-600 focus:ring-mono-500 border-mono-300 rounded">
                    <span class="ml-2 text-sm text-mono-700">Active (visible on pricing page)</span>
                </label>
            </div>
        </div>

        <div class="flex items-center justify-end gap-4 pt-6 border-t border-mono-200">
            <a href="admin-plans.php" class="px-6 py-2 border border-mono-300 rounded-lg text-mono-700 hover:bg-mono-50 transition-colors">
                Cancel
            </a>
            <button type="submit" 
                    class="bg-mono-900 text-white px-6 py-2 rounded-lg font-medium hover:bg-mono-800 transition-colors">
                <?= $isEdit ? 'Update Plan' : 'Create Plan' ?>
            </button>
        </div>
    </form>
</div>

