<?php
$plans = $plans ?? [];
?>

<div class="mb-8">
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-mono-900 mb-2">Manage Plans</h1>
            <p class="text-mono-600">Create and manage subscription plans dynamically</p>
        </div>
        <a href="admin-plans.php?action=create" 
           class="bg-mono-900 text-white px-6 py-3 rounded-lg font-medium hover:bg-mono-800 transition-colors">
            + Create New Plan
        </a>
    </div>
</div>

<?php if ($error = Session::flash('error')): ?>
    <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg text-red-700">
        <?= htmlspecialchars($error) ?>
    </div>
<?php endif; ?>

<?php if ($success = Session::flash('success')): ?>
    <div class="mb-6 p-4 bg-green-50 border border-green-200 rounded-lg text-green-700">
        <?= htmlspecialchars($success) ?>
    </div>
<?php endif; ?>

<div class="bg-white rounded-lg shadow-sm border border-mono-200 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-mono-50 border-b border-mono-200">
                <tr>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Name</th>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Monthly</th>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Annual</th>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Transactions</th>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Users</th>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Status</th>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Order</th>
                    <th class="text-right py-4 px-6 text-sm font-semibold text-mono-700">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-mono-100">
                <?php if (!empty($plans)): ?>
                    <?php foreach ($plans as $plan): ?>
                        <tr class="hover:bg-mono-50 transition-colors">
                            <td class="py-4 px-6">
                                <div>
                                    <p class="font-semibold text-mono-900"><?= htmlspecialchars($plan['name']) ?></p>
                                    <?php if ($plan['description']): ?>
                                        <p class="text-xs text-mono-500 mt-1"><?= htmlspecialchars(substr($plan['description'], 0, 50)) ?><?= strlen($plan['description']) > 50 ? '...' : '' ?></p>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="py-4 px-6 text-sm text-mono-700">$<?= number_format($plan['price_monthly'], 2) ?></td>
                            <td class="py-4 px-6 text-sm text-mono-700">$<?= number_format($plan['price_annual'], 2) ?></td>
                            <td class="py-4 px-6 text-sm text-mono-600">
                                <?= $plan['max_transactions'] ? number_format($plan['max_transactions']) : 'Unlimited' ?>
                            </td>
                            <td class="py-4 px-6 text-sm text-mono-600">
                                <?= $plan['max_users'] ? $plan['max_users'] : 'Unlimited' ?>
                            </td>
                            <td class="py-4 px-6">
                                <?php if ($plan['is_active']): ?>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-700">
                                        Active
                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-700">
                                        Inactive
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="py-4 px-6 text-sm text-mono-600"><?= $plan['sort_order'] ?></td>
                            <td class="py-4 px-6 text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="admin-plans.php?action=edit&id=<?= $plan['id'] ?>" 
                                       class="text-sm px-3 py-1 rounded text-mono-600 hover:text-mono-900 hover:bg-mono-100">
                                        Edit
                                    </a>
                                    <form method="POST" action="admin-plans.php" class="inline">
                                        <?= Security::csrfField() ?>
                                        <input type="hidden" name="action" value="toggle">
                                        <input type="hidden" name="id" value="<?= $plan['id'] ?>">
                                        <button type="submit" 
                                                class="text-sm px-3 py-1 rounded text-mono-600 hover:text-mono-900 hover:bg-mono-100">
                                            <?= $plan['is_active'] ? 'Deactivate' : 'Activate' ?>
                                        </button>
                                    </form>
                                    <form method="POST" action="admin-plans.php" class="inline" 
                                          onsubmit="return confirm('Are you sure you want to delete this plan? This action cannot be undone.');">
                                        <?= Security::csrfField() ?>
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="id" value="<?= $plan['id'] ?>">
                                        <button type="submit" 
                                                class="text-sm px-3 py-1 rounded text-red-600 hover:text-red-900 hover:bg-red-50">
                                            Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" class="py-12 text-center text-mono-500">
                            No plans found. <a href="admin-plans.php?action=create" class="text-mono-900 hover:underline">Create your first plan</a>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="mt-6 p-4 bg-mono-50 rounded-lg">
    <p class="text-sm text-mono-600">
        <strong>Note:</strong> Only active plans will be displayed on the pricing page. Inactive plans are hidden from customers but can be reactivated at any time.
    </p>
</div>

