<div class="bg-white rounded-lg shadow-lg p-8 border border-mono-200">
    <div class="text-center mb-8">
        <h1 class="text-3xl font-bold text-mono-900 mb-2">💳 Payment System</h1>
        <h2 class="text-xl text-mono-600">Reset your password</h2>
        <p class="text-sm text-mono-500 mt-2">Enter your email and we'll send you a reset link</p>
    </div>

    <?php if ($error = Session::flash('error')): ?>
        <div class="mb-4 p-4 bg-red-50 border border-red-200 rounded-lg text-red-700 text-sm">
            <?= htmlspecialchars($error) ?>
        </div>
    <?php endif; ?>

    <?php if ($success = Session::flash('success')): ?>
        <div class="mb-4 p-4 bg-green-50 border border-green-200 rounded-lg text-green-700 text-sm">
            <?= htmlspecialchars($success) ?>
        </div>
    <?php endif; ?>

    <?php if ($resetLink = Session::flash('reset_link')): ?>
        <div class="mb-4 p-4 bg-blue-50 border border-blue-200 rounded-lg">
            <p class="text-blue-700 text-sm mb-2"><strong>Development Mode:</strong> Reset link (remove in production):</p>
            <a href="<?= htmlspecialchars($resetLink) ?>" class="text-blue-600 hover:underline text-sm break-all">
                <?= htmlspecialchars($resetLink) ?>
            </a>
        </div>
    <?php endif; ?>

    <form method="POST" action="forgot-password.php" class="space-y-6">
        <div>
            <label for="email" class="block text-sm font-medium text-mono-700 mb-2">Email address</label>
            <input type="email" id="email" name="email" required 
                   class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"
                   placeholder="you@example.com">
        </div>

        <button type="submit" 
                class="w-full bg-mono-900 text-white py-3 px-4 rounded-lg font-medium hover:bg-mono-800 focus:outline-none focus:ring-2 focus:ring-mono-500 focus:ring-offset-2 transition-colors">
            Send Reset Link
        </button>
    </form>

    <div class="mt-6 text-center">
        <a href="login.php" class="text-sm text-mono-600 hover:text-mono-900">Back to login</a>
    </div>
</div>

