<div class="bg-white rounded-lg shadow-lg p-8 border border-mono-200">
    <div class="text-center mb-8">
        <h1 class="text-3xl font-bold text-mono-900 mb-2">💳 Payment System</h1>
        <h2 class="text-xl text-mono-600">Reset your password</h2>
    </div>

    <?php if ($error = Session::flash('error')): ?>
        <div class="mb-4 p-4 bg-red-50 border border-red-200 rounded-lg text-red-700 text-sm">
            <?= htmlspecialchars($error) ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="reset-password.php" class="space-y-6">
        <input type="hidden" name="token" value="<?= htmlspecialchars($_GET['token'] ?? '') ?>">

        <div>
            <label for="password" class="block text-sm font-medium text-mono-700 mb-2">New Password</label>
            <input type="password" id="password" name="password" required minlength="8"
                   class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"
                   placeholder="••••••••">
            <p class="mt-1 text-xs text-mono-500">Must be at least 8 characters</p>
        </div>

        <div>
            <label for="password_confirm" class="block text-sm font-medium text-mono-700 mb-2">Confirm New Password</label>
            <input type="password" id="password_confirm" name="password_confirm" required minlength="8"
                   class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"
                   placeholder="••••••••">
        </div>

        <button type="submit" 
                class="w-full bg-mono-900 text-white py-3 px-4 rounded-lg font-medium hover:bg-mono-800 focus:outline-none focus:ring-2 focus:ring-mono-500 focus:ring-offset-2 transition-colors">
            Reset Password
        </button>
    </form>

    <div class="mt-6 text-center">
        <a href="login.php" class="text-sm text-mono-600 hover:text-mono-900">Back to login</a>
    </div>
</div>

