<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title ?? 'Authentication') ?> - Payment System</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        // Configure Tailwind - wait for it to load
        function setupTailwind() {
            if (typeof tailwind !== 'undefined') {
                tailwind.config = {
                    theme: {
                        extend: {
                            colors: {
                                'mono': {
                                    50: '#fafafa',
                                    100: '#f5f5f5',
                                    200: '#e5e5e5',
                                    300: '#d4d4d4',
                                    400: '#a3a3a3',
                                    500: '#737373',
                                    600: '#525252',
                                    700: '#404040',
                                    800: '#262626',
                                    900: '#171717',
                                    950: '#0a0a0a',
                                }
                            }
                        }
                    }
                };
                return true;
            }
            return false;
        }
        // Try multiple times to ensure Tailwind loads
        let attempts = 0;
        function trySetup() {
            if (!setupTailwind() && attempts < 20) {
                attempts++;
                setTimeout(trySetup, 100);
            }
        }
        trySetup();
        window.addEventListener('load', trySetup);
    </script>
    <style>
        /* Fallback styles in case Tailwind doesn't load */
        body { font-family: system-ui, -apple-system, sans-serif; margin: 0; padding: 0; background: #fafafa; }
        .bg-mono-50 { background-color: #fafafa; }
        .min-h-screen { min-height: 100vh; }
        .flex { display: flex; }
        .flex-col { flex-direction: column; }
        .flex-1 { flex: 1; }
        .items-center { align-items: center; }
        .justify-center { justify-content: center; }
        .py-12 { padding-top: 3rem; padding-bottom: 3rem; }
        .px-4 { padding-left: 1rem; padding-right: 1rem; }
        .max-w-md { max-width: 28rem; }
        .w-full { width: 100%; }
        .space-y-8 > * + * { margin-top: 2rem; }
        .bg-white { background-color: #fff; }
        .rounded-lg { border-radius: 0.5rem; }
        .shadow-lg { box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1); }
        .p-8 { padding: 2rem; }
        .border { border-width: 1px; }
        .border-mono-200 { border-color: #e5e5e5; }
        .text-center { text-align: center; }
        .mb-8 { margin-bottom: 2rem; }
        .text-3xl { font-size: 1.875rem; line-height: 2.25rem; }
        .font-bold { font-weight: 700; }
        .text-mono-900 { color: #171717; }
        .mb-2 { margin-bottom: 0.5rem; }
        .text-xl { font-size: 1.25rem; line-height: 1.75rem; }
        .text-mono-600 { color: #525252; }
        .mb-4 { margin-bottom: 1rem; }
        .p-4 { padding: 1rem; }
        .bg-red-50 { background-color: #fef2f2; }
        .border-red-200 { border-color: #fecaca; }
        .rounded-lg { border-radius: 0.5rem; }
        .text-red-700 { color: #b91c1c; }
        .text-sm { font-size: 0.875rem; line-height: 1.25rem; }
        .bg-green-50 { background-color: #f0fdf4; }
        .border-green-200 { border-color: #bbf7d0; }
        .text-green-700 { color: #15803d; }
        .space-y-6 > * + * { margin-top: 1.5rem; }
        .block { display: block; }
        .text-mono-700 { color: #404040; }
        .mb-2 { margin-bottom: 0.5rem; }
        .w-full { width: 100%; }
        .px-4 { padding-left: 1rem; padding-right: 1rem; }
        .py-2 { padding-top: 0.5rem; padding-bottom: 0.5rem; }
        .border-mono-300 { border-color: #d4d4d4; }
        .rounded-lg { border-radius: 0.5rem; }
        .outline-none { outline: 2px solid transparent; outline-offset: 2px; }
        input { border: 1px solid #d4d4d4; padding: 0.5rem 1rem; border-radius: 0.5rem; width: 100%; }
        button { background-color: #171717; color: #fff; padding: 0.75rem 1rem; border-radius: 0.5rem; width: 100%; font-weight: 500; border: none; cursor: pointer; }
        button:hover { background-color: #262626; }
        a { color: #525252; text-decoration: none; }
        a:hover { color: #171717; }
        .mt-6 { margin-top: 1.5rem; }
    </style>
</head>
<body class="bg-mono-50 min-h-screen flex flex-col">
    <div class="flex-1 flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8">

