<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title ?? 'Dashboard') ?> - Payment System</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        // Configure Tailwind - wait for it to load
        function setupTailwind() {
            if (typeof tailwind !== 'undefined') {
                tailwind.config = {
                    theme: {
                        extend: {
                            colors: {
                                'mono': {
                                    50: '#fafafa',
                                    100: '#f5f5f5',
                                    200: '#e5e5e5',
                                    300: '#d4d4d4',
                                    400: '#a3a3a3',
                                    500: '#737373',
                                    600: '#525252',
                                    700: '#404040',
                                    800: '#262626',
                                    900: '#171717',
                                    950: '#0a0a0a',
                                }
                            }
                        }
                    }
                };
                return true;
            }
            return false;
        }
        // Try multiple times to ensure Tailwind loads
        let attempts = 0;
        function trySetup() {
            if (!setupTailwind() && attempts < 20) {
                attempts++;
                setTimeout(trySetup, 100);
            }
        }
        trySetup();
        window.addEventListener('load', trySetup);
    </script>
    <style>
        /* Fallback styles in case Tailwind doesn't load - Dashboard Layout */
        * { box-sizing: border-box; }
        body { font-family: system-ui, -apple-system, sans-serif; margin: 0; padding: 0; background: #fafafa; }
        .bg-mono-50 { background-color: #fafafa; }
        .min-h-screen { min-height: 100vh; }
        .flex { display: flex; }
        .flex-col { flex-direction: column; }
        .flex-1 { flex: 1; }
        .overflow-hidden { overflow: hidden; }
        .overflow-y-auto { overflow-y: auto; }
        .w-64 { width: 16rem; }
        .bg-mono-900 { background-color: #171717; }
        .text-mono-100 { color: #f5f5f5; }
        .border-r { border-right-width: 1px; }
        .border-mono-800 { border-color: #262626; }
        .p-6 { padding: 1.5rem; }
        .border-b { border-bottom-width: 1px; }
        .text-xl { font-size: 1.25rem; line-height: 1.75rem; }
        .font-bold { font-weight: 700; }
        .text-mono-50 { color: #fafafa; }
        .text-sm { font-size: 0.875rem; line-height: 1.25rem; }
        .text-mono-400 { color: #a3a3a3; }
        .mt-1 { margin-top: 0.25rem; }
        nav { flex: 1; padding: 1rem; }
        .space-y-1 > * + * { margin-top: 0.25rem; }
        .items-center { align-items: center; }
        .gap-3 { gap: 0.75rem; }
        .px-4 { padding-left: 1rem; padding-right: 1rem; }
        .py-1 { padding-top: 0.25rem; padding-bottom: 0.25rem; }
        .rounded-lg { border-radius: 0.5rem; }
        .text-mono-200 { color: #e5e5e5; }
        .hover\:bg-mono-800:hover { background-color: #262626; }
        .hover\:text-mono-50:hover { color: #fafafa; }
        .transition-colors { transition-property: color, background-color; transition-duration: 150ms; }
        .text-lg { font-size: 1.125rem; line-height: 1.75rem; }
        .bg-mono-800 { background-color: #262626; }
        .text-mono-50 { color: #fafafa; }
        .pt-4 { padding-top: 1rem; }
        .pb-2 { padding-bottom: 0.5rem; }
        .text-xs { font-size: 0.75rem; line-height: 1rem; }
        .font-semibold { font-weight: 600; }
        .text-mono-500 { color: #737373; }
        .uppercase { text-transform: uppercase; }
        .tracking-wider { letter-spacing: 0.05em; }
        .bg-white { background-color: #fff; }
        .border-mono-200 { border-color: #e5e5e5; }
        .px-8 { padding-left: 2rem; padding-right: 2rem; }
        .py-4 { padding-top: 1rem; padding-bottom: 1rem; }
        .justify-end { justify-content: flex-end; }
        .text-mono-900 { color: #171717; }
        .text-mono-500 { color: #737373; }
        .text-right { text-align: right; }
        .w-10 { width: 2.5rem; }
        .h-10 { height: 2.5rem; }
        .rounded-full { border-radius: 9999px; }
        .bg-mono-700 { background-color: #404040; }
        .text-white { color: #fff; }
        .font-semibold { font-weight: 600; }
        .text-mono-600 { color: #525252; }
        .hover\:text-mono-900:hover { color: #171717; }
        .p-8 { padding: 2rem; }
        .pb-4 { padding-bottom: 1rem; }
        .mb-8 { margin-bottom: 2rem; }
        .text-3xl { font-size: 1.875rem; line-height: 2.25rem; }
        .mb-2 { margin-bottom: 0.5rem; }
        .grid { display: grid; }
        .grid-cols-1 { grid-template-columns: repeat(1, minmax(0, 1fr)); }
        .gap-6 { gap: 1.5rem; }
        .rounded-lg { border-radius: 0.5rem; }
        .shadow-sm { box-shadow: 0 1px 2px 0 rgba(0,0,0,0.05); }
        .border { border-width: 1px; }
        .p-6 { padding: 1.5rem; }
        .justify-between { justify-content: space-between; }
        .mb-4 { margin-bottom: 1rem; }
        .text-2xl { font-size: 1.5rem; line-height: 2rem; }
        .space-y-1 > * + * { margin-top: 0.25rem; }
        .text-mono-500 { color: #737373; }
        .text-mono-600 { color: #525252; }
        .text-mono-700 { color: #404040; }
        .text-mono-800 { color: #262626; }
        .text-mono-900 { color: #171717; }
        .font-medium { font-weight: 500; }
        .font-semibold { font-weight: 600; }
        .font-bold { font-weight: 700; }
        .mb-4 { margin-bottom: 1rem; }
        .space-y-3 > * + * { margin-top: 0.75rem; }
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        .py-3 { padding-top: 0.75rem; padding-bottom: 0.75rem; }
        .px-4 { padding-left: 1rem; padding-right: 1rem; }
        .border-b { border-bottom-width: 1px; }
        .border-mono-100 { border-color: #f5f5f5; }
        .hover\:bg-mono-50:hover { background-color: #fafafa; }
        .overflow-x-auto { overflow-x: auto; }
        .w-full { width: 100%; }
        table { border-collapse: collapse; width: 100%; }
        th, td { padding: 0.75rem 1rem; text-align: left; }
        th { font-weight: 600; }
        .inline-flex { display: inline-flex; }
        .items-center { align-items: center; }
        .px-2\.5 { padding-left: 0.625rem; padding-right: 0.625rem; }
        .py-0\.5 { padding-top: 0.125rem; padding-bottom: 0.125rem; }
        .rounded-full { border-radius: 9999px; }
        .text-xs { font-size: 0.75rem; line-height: 1rem; }
        .font-medium { font-weight: 500; }
        .bg-mono-200 { background-color: #e5e5e5; }
        a { color: #525252; text-decoration: none; }
        a:hover { color: #171717; }
        button { cursor: pointer; border: none; }
        input, select, textarea { border: 1px solid #d4d4d4; padding: 0.5rem; border-radius: 0.25rem; }
        @media (min-width: 768px) {
            .md\:grid-cols-2 { grid-template-columns: repeat(2, minmax(0, 1fr)); }
        }
        @media (min-width: 1024px) {
            .lg\:grid-cols-3 { grid-template-columns: repeat(3, minmax(0, 1fr)); }
            .lg\:grid-cols-4 { grid-template-columns: repeat(4, minmax(0, 1fr)); }
        }
        /* Additional utility classes */
        .flex-shrink-0 { flex-shrink: 0; }
        .border-t { border-top-width: 1px; }
        .mt-auto { margin-top: auto; }
        .text-center { text-align: center; }
        .py-8 { padding-top: 2rem; padding-bottom: 2rem; }
        .text-mono-500 { color: #737373; }
        .number-format { font-variant-numeric: tabular-nums; }
    </style>
</head>
<body class="bg-mono-50 min-h-screen flex flex-col">
    <div class="flex flex-1 overflow-hidden">
        <!-- Sidebar Navigation -->
        <aside class="w-64 bg-mono-900 text-mono-100 flex flex-col border-r border-mono-800 flex-shrink-0">
            <div class="p-6 border-b border-mono-800">
                <h1 class="text-xl font-bold text-mono-50">💳 Payment System</h1>
                <p class="text-sm text-mono-400 mt-1">Transaction Tracker</p>
            </div>
            
            <nav class="flex-1 p-4 space-y-1 overflow-y-auto">
                <a href="index.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'index.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">🏠</span>
                    <span>Dashboard</span>
                </a>
                
                <div class="pt-4 pb-2">
                    <p class="px-4 text-xs font-semibold text-mono-500 uppercase tracking-wider">Reports</p>
                </div>
                
                <a href="summary.php?type=daily" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (isset($_GET['type']) && $_GET['type'] == 'daily') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">📅</span>
                    <span>Daily Summary</span>
                </a>
                
                <a href="summary.php?type=weekly" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (isset($_GET['type']) && $_GET['type'] == 'weekly') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">📆</span>
                    <span>Weekly Summary</span>
                </a>
                
                <a href="summary.php?type=monthly" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (isset($_GET['type']) && $_GET['type'] == 'monthly') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">🗓️</span>
                    <span>Monthly Summary</span>
                </a>
                
                <a href="summary.php?type=yearly" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (isset($_GET['type']) && $_GET['type'] == 'yearly') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">📘</span>
                    <span>Yearly Summary</span>
                </a>
                
                <div class="pt-4 pb-2">
                    <p class="px-4 text-xs font-semibold text-mono-500 uppercase tracking-wider">Transactions</p>
                </div>
                
                <a href="transaction-list.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'transaction-list.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">📄</span>
                    <span>All Transactions</span>
                </a>
                
                <div class="pt-4 pb-2">
                    <p class="px-4 text-xs font-semibold text-mono-500 uppercase tracking-wider">Settings</p>
                </div>
                
                <a href="settings.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'settings.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">⚙️</span>
                    <span>Settings</span>
                </a>
                
                <a href="pricing.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'pricing.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">💳</span>
                    <span>Pricing</span>
                </a>
                
                <div class="pt-4 pb-2">
                    <p class="px-4 text-xs font-semibold text-mono-500 uppercase tracking-wider">Admin</p>
                </div>
                
                <a href="admin-plans.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'admin-plans.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">💳</span>
                    <span>Manage Plans</span>
                </a>
                
                <a href="admin-users.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'admin-users.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">👥</span>
                    <span>Manage Users</span>
                </a>
            </nav>
            
            <div class="p-4 border-t border-mono-800 flex-shrink-0">
                <div class="text-xs text-mono-500">
                    <p>System Status</p>
                    <p class="text-mono-400 mt-1">✓ Operational</p>
                </div>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 overflow-y-auto flex flex-col">
            <!-- Top Header with User Info -->
            <div class="bg-white border-b border-mono-200 px-8 py-4 flex-shrink-0">
                <div class="flex justify-end items-center gap-4">
                    <div class="flex items-center gap-3">
                        <div class="text-right">
                            <p class="text-sm font-medium text-mono-900"><?= htmlspecialchars(Session::getUser()['name'] ?? 'User') ?></p>
                            <p class="text-xs text-mono-500"><?= htmlspecialchars(Session::getUser()['email'] ?? '') ?></p>
                        </div>
                        <div class="w-10 h-10 rounded-full bg-mono-700 flex items-center justify-center text-white font-semibold">
                            <?= strtoupper(substr(Session::getUser()['name'] ?? 'U', 0, 1)) ?>
                        </div>
                        <a href="logout.php" class="text-sm text-mono-600 hover:text-mono-900 font-medium transition-colors">
                            Sign Out
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="flex-1 p-8 pb-4">
