<?php
$stats = $stats ?? [];
$byBank = $byBank ?? [];
$dailyBreakdown = $dailyBreakdown ?? [];
$topMerchants = $topMerchants ?? [];
$data = $data ?? [];
?>

<div class="mb-8">
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-mono-900 mb-2"><?= htmlspecialchars($title) ?></h1>
            <p class="text-mono-600"><?= htmlspecialchars($subtitle ?? '') ?></p>
        </div>
        <div class="text-right">
            <p class="text-sm text-mono-600">Total Amount</p>
            <p class="text-3xl font-bold text-mono-900">$<?= number_format($total ?? 0, 2) ?></p>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
        <div class="flex items-center justify-between mb-2">
            <span class="text-sm font-medium text-mono-600">Transactions</span>
            <span class="text-2xl">📊</span>
        </div>
        <p class="text-2xl font-bold text-mono-900"><?= number_format($count ?? 0) ?></p>
    </div>

    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
        <div class="flex items-center justify-between mb-2">
            <span class="text-sm font-medium text-mono-600">Average</span>
            <span class="text-2xl">📈</span>
        </div>
        <p class="text-2xl font-bold text-mono-900">$<?= number_format($stats['avg_amount'] ?? 0, 2) ?></p>
    </div>

    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
        <div class="flex items-center justify-between mb-2">
            <span class="text-sm font-medium text-mono-600">Monthly Average</span>
            <span class="text-2xl">📅</span>
        </div>
        <p class="text-2xl font-bold text-mono-900">$<?= number_format(($total ?? 0) / 12, 2) ?></p>
    </div>

    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
        <div class="flex items-center justify-between mb-2">
            <span class="text-sm font-medium text-mono-600">Highest</span>
            <span class="text-2xl">⬆️</span>
        </div>
        <p class="text-2xl font-bold text-mono-900">$<?= number_format($stats['max_amount'] ?? 0, 2) ?></p>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
    <!-- Monthly Breakdown Chart -->
    <?php if (!empty($dailyBreakdown)): ?>
        <div class="lg:col-span-2 bg-white rounded-lg shadow-sm border border-mono-200 p-6">
            <h3 class="text-lg font-semibold text-mono-900 mb-4">Monthly Breakdown</h3>
            <div class="space-y-3 max-h-96 overflow-y-auto">
                <?php 
                // Group by month
                $monthlyData = [];
                foreach ($dailyBreakdown as $day) {
                    $month = date('Y-m', strtotime($day['date']));
                    if (!isset($monthlyData[$month])) {
                        $monthlyData[$month] = ['total' => 0, 'count' => 0];
                    }
                    $monthlyData[$month]['total'] += $day['total'];
                    $monthlyData[$month]['count'] += $day['count'];
                }
                ksort($monthlyData);
                $maxMonthly = max(array_column($monthlyData, 'total'));
                
                foreach ($monthlyData as $month => $data): 
                    $percentage = $maxMonthly > 0 ? ($data['total'] / $maxMonthly * 100) : 0;
                ?>
                    <div>
                        <div class="flex justify-between items-center mb-2">
                            <span class="text-mono-700 font-medium"><?= date("F Y", strtotime($month . '-01')) ?></span>
                            <span class="text-mono-900 font-semibold">$<?= number_format($data['total'], 2) ?></span>
                        </div>
                        <div class="w-full bg-mono-200 rounded-full h-3">
                            <div class="bg-mono-600 h-3 rounded-full transition-all" style="width: <?= $percentage ?>%"></div>
                        </div>
                        <p class="text-xs text-mono-500 mt-1"><?= $data['count'] ?> transactions</p>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- By Bank -->
    <?php if (!empty($byBank)): ?>
        <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
            <h3 class="text-lg font-semibold text-mono-900 mb-4">By Bank</h3>
            <div class="space-y-4">
                <?php 
                $totalBank = array_sum(array_column($byBank, 'total'));
                foreach ($byBank as $bank): 
                    $percentage = $totalBank > 0 ? ($bank['total'] / $totalBank * 100) : 0;
                ?>
                    <div>
                        <div class="flex justify-between items-center mb-2">
                            <span class="text-mono-700 font-medium"><?= htmlspecialchars($bank['bank']) ?></span>
                            <span class="text-mono-900 font-semibold">$<?= number_format($bank['total'], 2) ?></span>
                        </div>
                        <div class="w-full bg-mono-200 rounded-full h-2.5">
                            <div class="bg-mono-600 h-2.5 rounded-full transition-all" style="width: <?= $percentage ?>%"></div>
                        </div>
                        <p class="text-xs text-mono-500 mt-1"><?= $bank['count'] ?> transactions</p>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
    <!-- Top Merchants -->
    <?php if (!empty($topMerchants)): ?>
        <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
            <h3 class="text-lg font-semibold text-mono-900 mb-4">Top Merchants</h3>
            <div class="space-y-3">
                <?php foreach ($topMerchants as $merchant): ?>
                    <div class="flex justify-between items-center py-2 border-b border-mono-100 last:border-0">
                        <div class="flex-1">
                            <p class="text-mono-700 font-medium"><?= htmlspecialchars($merchant['merchant'] ?: 'Unknown') ?></p>
                            <p class="text-xs text-mono-500"><?= $merchant['count'] ?> transactions</p>
                        </div>
                        <span class="text-mono-900 font-semibold ml-4">$<?= number_format($merchant['total'], 2) ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Summary Stats -->
    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
        <h3 class="text-lg font-semibold text-mono-900 mb-4">Summary</h3>
        <div class="space-y-3">
            <div class="flex justify-between">
                <span class="text-mono-600">Total Transactions</span>
                <span class="font-semibold text-mono-900"><?= number_format($count ?? 0) ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-mono-600">Total Amount</span>
                <span class="font-semibold text-mono-900">$<?= number_format($total ?? 0, 2) ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-mono-600">Average per Transaction</span>
                <span class="font-semibold text-mono-900">$<?= number_format($stats['avg_amount'] ?? 0, 2) ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-mono-600">Average per Month</span>
                <span class="font-semibold text-mono-900">$<?= number_format(($total ?? 0) / 12, 2) ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-mono-600">Unique Banks</span>
                <span class="font-semibold text-mono-900"><?= $stats['bank_count'] ?? 0 ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-mono-600">Unique Merchants</span>
                <span class="font-semibold text-mono-900"><?= $stats['merchant_count'] ?? 0 ?></span>
            </div>
        </div>
    </div>
</div>

<!-- Transactions Table (Limited) -->
<div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
    <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-semibold text-mono-900">Recent Transactions</h3>
        <span class="text-sm text-mono-500">
            <?php 
            $displayCount = min(20, count($data ?? []));
            $totalCount = count($data ?? []);
            echo "Showing {$displayCount}" . ($totalCount > 20 ? " of {$totalCount}" : "");
            ?>
        </span>
    </div>
    <?php if (!empty($data)): ?>
        <div class="overflow-x-auto -mx-6 px-6">
            <table class="w-full min-w-full">
                <thead>
                    <tr class="border-b border-mono-200 bg-mono-50">
                        <th class="text-left py-3 px-4 text-sm font-semibold text-mono-700">Date</th>
                        <th class="text-left py-3 px-4 text-sm font-semibold text-mono-700">Time</th>
                        <th class="text-left py-3 px-4 text-sm font-semibold text-mono-700">Payer</th>
                        <th class="text-left py-3 px-4 text-sm font-semibold text-mono-700">Bank</th>
                        <th class="text-left py-3 px-4 text-sm font-semibold text-mono-700">Merchant</th>
                        <th class="text-right py-3 px-4 text-sm font-semibold text-mono-700">Amount</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-mono-100">
                    <?php foreach (array_slice($data, 0, 20) as $row): ?>
                        <tr class="hover:bg-mono-50 transition-colors">
                            <td class="py-3 px-4 text-sm text-mono-600 whitespace-nowrap"><?= date("M j, Y", strtotime($row['date'])) ?></td>
                            <td class="py-3 px-4 text-sm text-mono-600 whitespace-nowrap"><?= date("g:i A", strtotime($row['time'])) ?></td>
                            <td class="py-3 px-4 text-sm text-mono-700"><?= htmlspecialchars($row['payer_name']) ?></td>
                            <td class="py-3 px-4">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-mono-200 text-mono-800">
                                    <?= htmlspecialchars($row['bank']) ?>
                                </span>
                            </td>
                            <td class="py-3 px-4 text-sm text-mono-600"><?= htmlspecialchars($row['merchant'] ?: 'N/A') ?></td>
                            <td class="py-3 px-4 text-right text-sm font-semibold text-mono-900 whitespace-nowrap">$<?= number_format($row['amount'], 2) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php if (count($data) > 20): ?>
            <div class="mt-4 pt-4 border-t border-mono-200 text-center">
                <p class="text-sm text-mono-500">Showing 20 of <?= count($data) ?> transactions. <a href="transaction-list.php" class="text-mono-900 hover:text-mono-700 font-medium">View all →</a></p>
            </div>
        <?php endif; ?>
    <?php else: ?>
        <div class="py-12 text-center">
            <p class="text-mono-500 text-sm">No transactions found for this period.</p>
        </div>
    <?php endif; ?>
</div>

