<?php

class Session
{
    public static function start()
    {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }

    public static function set($key, $value)
    {
        self::start();
        $_SESSION[$key] = $value;
    }

    public static function get($key, $default = null)
    {
        self::start();
        return $_SESSION[$key] ?? $default;
    }

    public static function has($key)
    {
        self::start();
        return isset($_SESSION[$key]);
    }

    public static function remove($key)
    {
        self::start();
        unset($_SESSION[$key]);
    }

    public static function destroy()
    {
        self::start();
        session_destroy();
        $_SESSION = [];
    }

    public static function flash($key, $value = null)
    {
        self::start();
        if ($value === null) {
            $message = $_SESSION['_flash'][$key] ?? null;
            unset($_SESSION['_flash'][$key]);
            return $message;
        }
        $_SESSION['_flash'][$key] = $value;
    }

    public static function setUser($user)
    {
        self::set('user_id', $user['id']);
        self::set('user_name', $user['name']);
        self::set('user_email', $user['email']);
    }

    public static function getUser()
    {
        if (!self::has('user_id')) {
            return null;
        }

        return [
            'id' => self::get('user_id'),
            'name' => self::get('user_name'),
            'email' => self::get('user_email')
        ];
    }

    public static function setOrganization($organization)
    {
        self::set('organization_id', $organization['id']);
        self::set('organization_name', $organization['name']);
        self::set('organization_slug', $organization['slug']);
    }

    public static function getOrganization()
    {
        if (!self::has('organization_id')) {
            return null;
        }

        return [
            'id' => self::get('organization_id'),
            'name' => self::get('organization_name'),
            'slug' => self::get('organization_slug')
        ];
    }

    public static function isAuthenticated()
    {
        return self::has('user_id');
    }
}

