-- Add organization_id and user_id to transactions table
-- Check if columns exist first to avoid errors

-- Add organization_id column if it doesn't exist
SET @col_exists = 0;
SELECT COUNT(*) INTO @col_exists 
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'transactions' 
  AND COLUMN_NAME = 'organization_id';

SET @sql = IF(@col_exists = 0,
  'ALTER TABLE `transactions` ADD COLUMN `organization_id` int(11) DEFAULT NULL AFTER `id`',
  'SELECT "Column organization_id already exists" AS message');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add user_id column if it doesn't exist
SET @col_exists = 0;
SELECT COUNT(*) INTO @col_exists 
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'transactions' 
  AND COLUMN_NAME = 'user_id';

SET @sql = IF(@col_exists = 0,
  'ALTER TABLE `transactions` ADD COLUMN `user_id` int(11) DEFAULT NULL AFTER `organization_id`',
  'SELECT "Column user_id already exists" AS message');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add indexes if they don't exist
SET @idx_exists = 0;
SELECT COUNT(*) INTO @idx_exists 
FROM INFORMATION_SCHEMA.STATISTICS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'transactions' 
  AND INDEX_NAME = 'idx_organization_id';

SET @sql = IF(@idx_exists = 0,
  'ALTER TABLE `transactions` ADD KEY `idx_organization_id` (`organization_id`)',
  'SELECT "Index idx_organization_id already exists" AS message');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @idx_exists = 0;
SELECT COUNT(*) INTO @idx_exists 
FROM INFORMATION_SCHEMA.STATISTICS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'transactions' 
  AND INDEX_NAME = 'idx_user_id';

SET @sql = IF(@idx_exists = 0,
  'ALTER TABLE `transactions` ADD KEY `idx_user_id` (`user_id`)',
  'SELECT "Index idx_user_id already exists" AS message');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add foreign keys if they don't exist
SET @fk_exists = 0;
SELECT COUNT(*) INTO @fk_exists 
FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'transactions' 
  AND CONSTRAINT_NAME = 'transactions_ibfk_1';

SET @sql = IF(@fk_exists = 0,
  'ALTER TABLE `transactions` ADD FOREIGN KEY (`organization_id`) REFERENCES `organizations`(`id`) ON DELETE CASCADE',
  'SELECT "Foreign key for organization_id already exists" AS message');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @fk_exists = 0;
SELECT COUNT(*) INTO @fk_exists 
FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'transactions' 
  AND CONSTRAINT_NAME = 'transactions_ibfk_2';

SET @sql = IF(@fk_exists = 0,
  'ALTER TABLE `transactions` ADD FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE SET NULL',
  'SELECT "Foreign key for user_id already exists" AS message');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

