<?php
$user = $user ?? null;
$organizations = $organizations ?? [];
$isEdit = isset($user);
?>

<div class="mb-8">
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-mono-900 mb-2"><?= $isEdit ? 'Edit User' : 'Create New User' ?></h1>
            <p class="text-mono-600"><?= $isEdit ? 'Update user information' : 'Add a new user to the system' ?></p>
        </div>
        <a href="admin-users.php" class="text-mono-600 hover:text-mono-900">
            ← Back to Users
        </a>
    </div>
</div>

<?php if ($error = Session::flash('error')): ?>
    <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg text-red-700">
        <?= htmlspecialchars($error) ?>
    </div>
<?php endif; ?>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    <!-- Main Form -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-8">
            <form method="POST" action="admin-users.php" class="space-y-6">
                <input type="hidden" name="action" value="<?= $isEdit ? 'update' : 'store' ?>">
                <?php if ($isEdit): ?>
                    <input type="hidden" name="id" value="<?= $user['id'] ?>">
                <?php endif; ?>

                <!-- Name -->
                <div>
                    <label for="name" class="block text-sm font-medium text-mono-700 mb-2">Full Name *</label>
                    <input type="text" id="name" name="name" required
                           value="<?= htmlspecialchars($user['name'] ?? '') ?>"
                           placeholder="John Doe"
                           class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                </div>

                <!-- Email -->
                <div>
                    <label for="email" class="block text-sm font-medium text-mono-700 mb-2">Email Address *</label>
                    <input type="email" id="email" name="email" required
                           value="<?= htmlspecialchars($user['email'] ?? '') ?>"
                           placeholder="user@example.com"
                           class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                </div>

                <!-- Password -->
                <div>
                    <label for="password" class="block text-sm font-medium text-mono-700 mb-2">
                        Password <?= $isEdit ? '(leave blank to keep current)' : '*' ?>
                    </label>
                    <input type="password" id="password" name="password" <?= $isEdit ? '' : 'required' ?>
                           minlength="8"
                           placeholder="<?= $isEdit ? 'Enter new password' : 'Minimum 8 characters' ?>"
                           class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                    <?php if ($isEdit): ?>
                        <p class="mt-1 text-xs text-mono-500">Leave blank to keep the current password</p>
                    <?php else: ?>
                        <p class="mt-1 text-xs text-mono-500">Must be at least 8 characters long</p>
                    <?php endif; ?>
                </div>

                <!-- Confirm Password -->
                <div>
                    <label for="password_confirm" class="block text-sm font-medium text-mono-700 mb-2">
                        Confirm Password <?= $isEdit ? '(if changing password)' : '*' ?>
                    </label>
                    <input type="password" id="password_confirm" name="password_confirm" <?= $isEdit ? '' : 'required' ?>
                           minlength="8"
                           placeholder="Confirm password"
                           class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                </div>

                <div class="flex items-center justify-end gap-4 pt-6 border-t border-mono-200">
                    <a href="admin-users.php" class="px-6 py-2 border border-mono-300 rounded-lg text-mono-700 hover:bg-mono-50 transition-colors">
                        Cancel
                    </a>
                    <button type="submit" 
                            class="bg-mono-900 text-white px-6 py-2 rounded-lg font-medium hover:bg-mono-800 transition-colors">
                        <?= $isEdit ? 'Update User' : 'Create User' ?>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Sidebar Info -->
    <div class="space-y-6">
        <?php if ($isEdit): ?>
            <!-- User Info -->
            <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
                <h3 class="text-lg font-semibold text-mono-900 mb-4">User Information</h3>
                <div class="space-y-3 text-sm">
                    <div>
                        <p class="text-mono-600">User ID</p>
                        <p class="text-mono-900 font-mono">#<?= $user['id'] ?></p>
                    </div>
                    <div>
                        <p class="text-mono-600">Created</p>
                        <p class="text-mono-900"><?= date("M j, Y g:i A", strtotime($user['created_at'])) ?></p>
                    </div>
                    <div>
                        <p class="text-mono-600">Last Updated</p>
                        <p class="text-mono-900"><?= date("M j, Y g:i A", strtotime($user['updated_at'])) ?></p>
                    </div>
                    <?php if ($user['email_verified_at']): ?>
                        <div>
                            <p class="text-mono-600">Email Verified</p>
                            <p class="text-green-600"><?= date("M j, Y", strtotime($user['email_verified_at'])) ?></p>
                        </div>
                    <?php else: ?>
                        <div>
                            <p class="text-mono-600">Email Status</p>
                            <p class="text-red-600">Not verified</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Organizations -->
            <?php if (!empty($organizations)): ?>
                <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
                    <h3 class="text-lg font-semibold text-mono-900 mb-4">Organizations</h3>
                    <div class="space-y-3">
                        <?php foreach ($organizations as $org): ?>
                            <div class="p-3 bg-mono-50 rounded-lg">
                                <p class="font-medium text-mono-900"><?= htmlspecialchars($org['name']) ?></p>
                                <p class="text-xs text-mono-500 mt-1">
                                    Role: <span class="font-medium"><?= ucfirst($org['role']) ?></span>
                                </p>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
                    <h3 class="text-lg font-semibold text-mono-900 mb-4">Organizations</h3>
                    <p class="text-sm text-mono-500">This user is not part of any organization yet.</p>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <!-- Help Info -->
            <div class="bg-mono-50 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-mono-900 mb-3">Creating a User</h3>
                <ul class="space-y-2 text-sm text-mono-600">
                    <li>• User will be able to login immediately</li>
                    <li>• Email must be unique</li>
                    <li>• Password must be at least 8 characters</li>
                    <li>• User can create or join organizations after login</li>
                </ul>
            </div>
        <?php endif; ?>
    </div>
</div>

