<?php
$users = $users ?? [];
$search = $_GET['search'] ?? '';
?>

<div class="mb-8">
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-mono-900 mb-2">Manage Users</h1>
            <p class="text-mono-600">View and manage all system users</p>
        </div>
        <a href="admin-users.php?action=create" 
           class="bg-mono-900 text-white px-6 py-3 rounded-lg font-medium hover:bg-mono-800 transition-colors">
            + Create New User
        </a>
    </div>
</div>

<?php if ($error = Session::flash('error')): ?>
    <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg text-red-700">
        <?= htmlspecialchars($error) ?>
    </div>
<?php endif; ?>

<?php if ($success = Session::flash('success')): ?>
    <div class="mb-6 p-4 bg-green-50 border border-green-200 rounded-lg text-green-700">
        <?= htmlspecialchars($success) ?>
    </div>
<?php endif; ?>

<!-- Search Bar -->
<div class="mb-6 bg-white rounded-lg shadow-sm border border-mono-200 p-4">
    <form method="GET" action="admin-users.php" class="flex gap-4">
        <input type="text" name="search" value="<?= htmlspecialchars($search) ?>"
               placeholder="Search by name or email..."
               class="flex-1 px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
        <button type="submit" 
                class="bg-mono-900 text-white px-6 py-2 rounded-lg font-medium hover:bg-mono-800 transition-colors">
            Search
        </button>
        <?php if ($search): ?>
            <a href="admin-users.php" 
               class="px-6 py-2 border border-mono-300 rounded-lg text-mono-700 hover:bg-mono-50 transition-colors">
                Clear
            </a>
        <?php endif; ?>
    </form>
</div>

<div class="bg-white rounded-lg shadow-sm border border-mono-200 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-mono-50 border-b border-mono-200">
                <tr>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">User</th>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Email</th>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Organizations</th>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Transactions</th>
                    <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Joined</th>
                    <th class="text-right py-4 px-6 text-sm font-semibold text-mono-700">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-mono-100">
                <?php if (!empty($users)): ?>
                    <?php foreach ($users as $user): ?>
                        <?php
                        $currentUser = Session::getUser();
                        $isCurrentUser = $currentUser && $currentUser['id'] == $user['id'];
                        ?>
                        <tr class="hover:bg-mono-50 transition-colors">
                            <td class="py-4 px-6">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-full bg-mono-700 flex items-center justify-center text-mono-200 font-semibold">
                                        <?= strtoupper(substr($user['name'], 0, 1)) ?>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-mono-900"><?= htmlspecialchars($user['name']) ?></p>
                                        <?php if ($isCurrentUser): ?>
                                            <span class="text-xs text-mono-500">(You)</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td class="py-4 px-6 text-sm text-mono-700"><?= htmlspecialchars($user['email']) ?></td>
                            <td class="py-4 px-6 text-sm text-mono-600">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-mono-200 text-mono-800">
                                    <?= $user['organization_count'] ?? 0 ?> org<?= ($user['organization_count'] ?? 0) != 1 ? 's' : '' ?>
                                </span>
                            </td>
                            <td class="py-4 px-6 text-sm text-mono-600">
                                <?= number_format($user['transaction_count'] ?? 0) ?>
                            </td>
                            <td class="py-4 px-6 text-sm text-mono-600">
                                <?= date("M j, Y", strtotime($user['created_at'])) ?>
                            </td>
                            <td class="py-4 px-6 text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="admin-users.php?action=edit&id=<?= $user['id'] ?>" 
                                       class="text-sm px-3 py-1 rounded text-mono-600 hover:text-mono-900 hover:bg-mono-100">
                                        Edit
                                    </a>
                                    <?php if (!$isCurrentUser): ?>
                                        <form method="POST" action="admin-users.php" class="inline" 
                                              onsubmit="return confirm('Are you sure you want to delete this user? This action cannot be undone.');">
                                            <input type="hidden" name="action" value="delete">
                                            <input type="hidden" name="id" value="<?= $user['id'] ?>">
                                            <button type="submit" 
                                                    class="text-sm px-3 py-1 rounded text-red-600 hover:text-red-900 hover:bg-red-50">
                                                Delete
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <span class="text-sm px-3 py-1 rounded text-mono-400 cursor-not-allowed">Delete</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="py-12 text-center text-mono-500">
                            <?php if ($search): ?>
                                No users found matching "<?= htmlspecialchars($search) ?>". 
                                <a href="admin-users.php" class="text-mono-900 hover:underline">View all users</a>
                            <?php else: ?>
                                No users found. <a href="admin-users.php?action=create" class="text-mono-900 hover:underline">Create your first user</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php if (!empty($users)): ?>
    <div class="mt-6 p-4 bg-mono-50 rounded-lg">
        <p class="text-sm text-mono-600">
            <strong>Total Users:</strong> <?= count($users) ?> | 
            <strong>Total Organizations:</strong> <?= array_sum(array_column($users, 'organization_count')) ?> | 
            <strong>Total Transactions:</strong> <?= number_format(array_sum(array_column($users, 'transaction_count'))) ?>
        </p>
    </div>
<?php endif; ?>

<!-- Telegram Webhook Management -->
<div class="mt-8">
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-mono-900 mb-2">Telegram Webhook Management</h2>
        <p class="text-mono-600">Manage Telegram bot webhooks for organizations</p>
    </div>

    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6 mb-6">
        <div class="mb-4">
            <label class="block text-sm font-medium text-mono-700 mb-2">Base URL</label>
            <div class="flex gap-2">
                <input type="text" id="base_url_input" value="<?= htmlspecialchars($baseUrl ?? '') ?>"
                       placeholder="https://yourdomain.com"
                       class="flex-1 px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                <button onclick="updateWebhookUrl()" 
                        class="px-4 py-2 bg-mono-900 text-white rounded-lg hover:bg-mono-800 transition-colors">
                    Update
                </button>
            </div>
            <p class="mt-2 text-sm text-mono-500">
                Webhook URL: <span id="webhook_url_display" class="font-mono text-mono-900"><?= htmlspecialchars($webhookUrl ?? '') ?></span>
            </p>
        </div>
    </div>

    <?php if (!empty($organizationsWithWebhooks)): ?>
        <div class="bg-white rounded-lg shadow-sm border border-mono-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-mono-50 border-b border-mono-200">
                        <tr>
                            <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Organization</th>
                            <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Bot Token</th>
                            <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Webhook Status</th>
                            <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Webhook URL</th>
                            <th class="text-right py-4 px-6 text-sm font-semibold text-mono-700">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-mono-100">
                        <?php foreach ($organizationsWithWebhooks as $item): 
                            $org = $item['organization'];
                            $webhookInfo = $item['webhook_info'];
                            $hasToken = !empty($org['telegram_bot_token']);
                            $webhookSet = $hasToken && $webhookInfo && $webhookInfo['success'] && !empty($webhookInfo['webhook']['url']);
                        ?>
                            <tr class="hover:bg-mono-50 transition-colors">
                                <td class="py-4 px-6">
                                    <p class="font-semibold text-mono-900"><?= htmlspecialchars($org['name']) ?></p>
                                    <p class="text-xs text-mono-500">ID: <?= $org['id'] ?></p>
                                </td>
                                <td class="py-4 px-6">
                                    <?php if ($hasToken): ?>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-700">
                                            Configured
                                        </span>
                                        <p class="text-xs text-mono-500 mt-1 font-mono">
                                            <?= htmlspecialchars(substr($org['telegram_bot_token'], 0, 20)) ?>...
                                        </p>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-700">
                                            Not Set
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td class="py-4 px-6">
                                    <?php if ($webhookSet): ?>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-700">
                                            Active
                                        </span>
                                        <?php if (isset($webhookInfo['webhook']['pending_update_count']) && $webhookInfo['webhook']['pending_update_count'] > 0): ?>
                                            <p class="text-xs text-yellow-600 mt-1">
                                                <?= $webhookInfo['webhook']['pending_update_count'] ?> pending updates
                                            </p>
                                        <?php endif; ?>
                                    <?php elseif ($hasToken): ?>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-700">
                                            Not Set
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-mono-100 text-mono-600">
                                            N/A
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td class="py-4 px-6">
                                    <?php if ($webhookSet): ?>
                                        <p class="text-xs text-mono-600 font-mono break-all">
                                            <?= htmlspecialchars($webhookInfo['webhook']['url']) ?>
                                        </p>
                                        <?php if (isset($webhookInfo['webhook']['last_error_date'])): ?>
                                            <p class="text-xs text-red-600 mt-1">
                                                Last error: <?= date("M j, Y g:i A", $webhookInfo['webhook']['last_error_date']) ?>
                                            </p>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <p class="text-xs text-mono-400">-</p>
                                    <?php endif; ?>
                                </td>
                                <td class="py-4 px-6 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                        <?php if ($hasToken): ?>
                                            <?php if ($webhookSet): ?>
                                                <form method="POST" action="admin-users.php" class="inline" 
                                                      onsubmit="return confirm('Are you sure you want to delete this webhook?');">
                                                    <input type="hidden" name="action" value="delete_webhook">
                                                    <input type="hidden" name="organization_id" value="<?= $org['id'] ?>">
                                                    <button type="submit" 
                                                            class="text-sm px-3 py-1 rounded text-red-600 hover:text-red-900 hover:bg-red-50">
                                                        Delete Webhook
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                            <form method="POST" action="admin-users.php" class="inline">
                                                <input type="hidden" name="action" value="set_webhook">
                                                <input type="hidden" name="organization_id" value="<?= $org['id'] ?>">
                                                <input type="hidden" name="base_url" id="base_url_<?= $org['id'] ?>" value="<?= htmlspecialchars($baseUrl ?? '') ?>">
                                                <button type="submit" 
                                                        class="text-sm px-3 py-1 rounded text-mono-600 hover:text-mono-900 hover:bg-mono-100">
                                                    <?= $webhookSet ? 'Update' : 'Set' ?> Webhook
                                                </button>
                                            </form>
                                        <?php else: ?>
                                            <span class="text-sm text-mono-400">Configure bot token first</span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-12 text-center">
            <p class="text-mono-500">No organizations found.</p>
        </div>
    <?php endif; ?>
</div>

<script>
function updateWebhookUrl() {
    const baseUrl = document.getElementById('base_url_input').value.trim();
    if (!baseUrl) {
        alert('Please enter a base URL');
        return;
    }
    
    // Remove trailing slash
    const cleanUrl = baseUrl.replace(/\/$/, '');
    const webhookUrl = cleanUrl + '/webhook.php';
    
    document.getElementById('webhook_url_display').textContent = webhookUrl;
    
    // Update all hidden base_url inputs
    document.querySelectorAll('[id^="base_url_"]').forEach(input => {
        input.value = cleanUrl;
    });
}
</script>

