<?php
$orgData = $orgData ?? [];
$telegramAccessList = $telegramAccessList ?? [];
$currentSubscription = $currentSubscription ?? [];
$organization = Session::getOrganization();
?>

<div class="mb-8">
    <h1 class="text-3xl font-bold text-mono-900 mb-2">Settings</h1>
    <p class="text-mono-600">Manage your organization settings and Telegram configuration</p>
</div>

<?php if (!$organization): ?>
    <div class="mb-6 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
        <p class="text-yellow-800">
            <strong>No organization found.</strong> Please create an organization below. 
            If you just registered, your organization should have been created automatically. 
            If not, please create one now.
        </p>
    </div>
<?php endif; ?>

<?php if ($error = Session::flash('error')): ?>
    <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg text-red-700">
        <?= htmlspecialchars($error) ?>
    </div>
<?php endif; ?>

<?php if ($success = Session::flash('success')): ?>
    <div class="mb-6 p-4 bg-green-50 border border-green-200 rounded-lg text-green-700">
        <?= htmlspecialchars($success) ?>
    </div>
<?php endif; ?>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    <!-- Main Settings -->
    <div class="lg:col-span-2 space-y-6">
        <!-- Organization Settings -->
        <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
            <h2 class="text-xl font-semibold text-mono-900 mb-4">Organization Settings</h2>
            
            <form method="POST" action="settings.php" class="space-y-4">
                <input type="hidden" name="action" value="update_organization">
                
                <div>
                    <label for="name" class="block text-sm font-medium text-mono-700 mb-2">Organization Name</label>
                    <input type="text" id="name" name="name" required
                           value="<?= htmlspecialchars($orgData['name'] ?? '') ?>"
                           placeholder="Enter your organization name"
                           class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                    <?php if (!$organization): ?>
                        <p class="mt-1 text-xs text-mono-500">This will create a new organization for your account.</p>
                    <?php endif; ?>
                </div>

                <div>
                    <label for="telegram_bot_token" class="block text-sm font-medium text-mono-700 mb-2">Telegram Bot Token</label>
                    <input type="text" id="telegram_bot_token" name="telegram_bot_token"
                           value="<?= htmlspecialchars($orgData['telegram_bot_token'] ?? '') ?>"
                           placeholder="123456789:ABCdefGHIjklMNOpqrsTUVwxyz"
                           class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                    <p class="mt-1 text-xs text-mono-500">Get your bot token from @BotFather on Telegram</p>
                </div>

                <button type="submit" 
                        class="bg-mono-900 text-white px-6 py-2 rounded-lg font-medium hover:bg-mono-800 transition-colors">
                    Save Changes
                </button>
            </form>
        </div>

        <!-- Telegram Access Control -->
        <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
            <h2 class="text-xl font-semibold text-mono-900 mb-4">Telegram Access Control</h2>
            <p class="text-sm text-mono-600 mb-4">Manage which Telegram users/groups can send payment notifications to your organization.</p>
            
            <!-- Add New Access -->
            <form method="POST" action="settings.php" class="mb-6 p-4 bg-mono-50 rounded-lg">
                <input type="hidden" name="action" value="add_telegram_access">
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label for="chat_id" class="block text-sm font-medium text-mono-700 mb-2">Chat ID / Group ID</label>
                        <input type="text" id="chat_id" name="chat_id" required
                               placeholder="123456789 or -1001234567890"
                               class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                    </div>
                    
                    <div>
                        <label for="chat_type" class="block text-sm font-medium text-mono-700 mb-2">Type</label>
                        <select id="chat_type" name="chat_type" required
                                class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                            <option value="user">User</option>
                            <option value="group">Group</option>
                            <option value="channel">Channel</option>
                        </select>
                    </div>
                    
                    <div>
                        <label for="chat_title" class="block text-sm font-medium text-mono-700 mb-2">Title (Optional)</label>
                        <input type="text" id="chat_title" name="chat_title"
                               placeholder="John Doe or Group Name"
                               class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                    </div>
                </div>
                
                <button type="submit" class="mt-4 bg-mono-900 text-white px-6 py-2 rounded-lg font-medium hover:bg-mono-800 transition-colors">
                    Add Access
                </button>
            </form>

            <!-- Access List -->
            <?php if (!empty($telegramAccessList)): ?>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="border-b border-mono-200">
                                <th class="text-left py-3 px-4 text-sm font-semibold text-mono-700">Chat ID</th>
                                <th class="text-left py-3 px-4 text-sm font-semibold text-mono-700">Type</th>
                                <th class="text-left py-3 px-4 text-sm font-semibold text-mono-700">Title</th>
                                <th class="text-left py-3 px-4 text-sm font-semibold text-mono-700">Status</th>
                                <th class="text-right py-3 px-4 text-sm font-semibold text-mono-700">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($telegramAccessList as $access): ?>
                                <tr class="border-b border-mono-100 hover:bg-mono-50">
                                    <td class="py-3 px-4 text-sm text-mono-700 font-mono"><?= htmlspecialchars($access['chat_id']) ?></td>
                                    <td class="py-3 px-4">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-mono-200 text-mono-800">
                                            <?= htmlspecialchars(ucfirst($access['chat_type'])) ?>
                                        </span>
                                    </td>
                                    <td class="py-3 px-4 text-sm text-mono-600"><?= htmlspecialchars($access['chat_title'] ?: 'N/A') ?></td>
                                    <td class="py-3 px-4">
                                        <?php if ($access['is_active']): ?>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-700">
                                                Active
                                            </span>
                                        <?php else: ?>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-700">
                                                Inactive
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="py-3 px-4 text-right">
                                        <div class="flex items-center justify-end gap-2">
                                            <form method="POST" action="settings.php" class="inline">
                                                <input type="hidden" name="action" value="toggle_telegram_access">
                                                <input type="hidden" name="id" value="<?= $access['id'] ?>">
                                                <button type="submit" 
                                                        class="text-xs px-3 py-1 rounded text-mono-600 hover:text-mono-900 hover:bg-mono-100">
                                                    <?= $access['is_active'] ? 'Deactivate' : 'Activate' ?>
                                                </button>
                                            </form>
                                            <form method="POST" action="settings.php" class="inline" 
                                                  onsubmit="return confirm('Are you sure you want to delete this access?');">
                                                <input type="hidden" name="action" value="delete_telegram_access">
                                                <input type="hidden" name="id" value="<?= $access['id'] ?>">
                                                <button type="submit" 
                                                        class="text-xs px-3 py-1 rounded text-red-600 hover:text-red-900 hover:bg-red-50">
                                                    Delete
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="text-mono-500 text-sm py-8 text-center">No Telegram access configured. Add one above to get started.</p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="space-y-6">
        <!-- Subscription Info -->
        <?php if ($currentSubscription): ?>
            <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
                <h3 class="text-lg font-semibold text-mono-900 mb-4">Current Plan</h3>
                <div class="space-y-3">
                    <div>
                        <p class="text-sm text-mono-600">Plan</p>
                        <p class="text-lg font-semibold text-mono-900"><?= htmlspecialchars($currentSubscription['plan_name']) ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-mono-600">Billing</p>
                        <p class="text-mono-900"><?= ucfirst($currentSubscription['billing_period']) ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-mono-600">Status</p>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                            <?= $currentSubscription['status'] === 'active' ? 'bg-green-100 text-green-700' : 'bg-yellow-100 text-yellow-700' ?>">
                            <?= ucfirst($currentSubscription['status']) ?>
                        </span>
                    </div>
                    <div>
                        <p class="text-sm text-mono-600">Expires</p>
                        <p class="text-mono-900"><?= date("M j, Y", strtotime($currentSubscription['ends_at'])) ?></p>
                    </div>
                    <a href="pricing.php" class="block w-full text-center bg-mono-900 text-white py-2 rounded-lg font-medium hover:bg-mono-800 transition-colors">
                        Manage Plan
                    </a>
                </div>
            </div>
        <?php else: ?>
            <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
                <h3 class="text-lg font-semibold text-mono-900 mb-4">Subscription</h3>
                <p class="text-sm text-mono-600 mb-4">No active subscription. Choose a plan to get started.</p>
                <a href="pricing.php" class="block w-full text-center bg-mono-900 text-white py-2 rounded-lg font-medium hover:bg-mono-800 transition-colors">
                    View Plans
                </a>
            </div>
        <?php endif; ?>

        <!-- Help -->
        <div class="bg-mono-50 rounded-lg p-6">
            <h3 class="text-lg font-semibold text-mono-900 mb-3">Need Help?</h3>
            <ul class="space-y-2 text-sm text-mono-600">
                <li>• How to get Chat ID: Forward a message from the user/group to @userinfobot</li>
                <li>• Group IDs are negative numbers (e.g., -1001234567890)</li>
                <li>• Only active access entries can send payment notifications</li>
            </ul>
        </div>
    </div>
</div>

